---
aliases:
  - Metrics
---

### Structure
- Prompt
- Why product exists - rationale, market, motivation for this product to exist 
- Set reasonable, measurable goals - How would we know if product is successful
- Build user journey steps
- Explain metrics and counter-metrics
- Tradeoff question - for given constraints or opportunities, what would you do? Tie it back to rationale or goal
- If NSM goes up and users are unhappy, how would you assess this situation? 


Told Dvir - I had Meta Verified for analytical thinking, parking solution for product sense



### Practice questions
[[FB Events]]
[[FB Live]]
[[Horizon World]]
[[Meta Workchat feature]]
[[Netflix Podcasts]]
[[AI Pin]]

### Interview prep material
Analytical thinking interview example - [Meta Product Manager Interview - Analytical Thinking (Execution) Interview Response by FB PM](https://www.youtube.com/watch?v=dt7OrazE6SQ&ab_channel=ProductAlliance)
[13 Product-Sense Interview Questions & Tips for Data Scientists (datalemur.com)](https://datalemur.com/blog/product-sense-interview-questions)
Growth & retention flywheel metrics for Duolingo - https://blog.duolingo.com/growth-model-duolingo/
### Marketplace metrics
[[Marketplace]]
### Key metrics - New product
- **Awareness** 
	- % organic traffic
	- Impressions
	- CTR on marketing efforts - Ads, Emails, QR codes
	- Bounce rate on landing page
	- Social media mentions
- **Acquisition**
	- New users acquired
	- Conversion rate (% users completing desired action) (usually relevant for bottom of the funnel, for achieving a specific goal)
	- Click-through-rate (usually relevant for top of the funnel)
- **Retention**
	- DAU, MAU
	- Stickiness = DAU/MAU
	- Retention rate, churn rate
	- Engagement (average time spent) 
	- Feature adoption rate (% of users adopting to XX number of features out of all features)
- **Monetization**
	- CLV
	- CAC, months to recover CAC (SaaS)
	- MRR monthly recurring revenue (Saas)
	- Average revenue per user
	- Number of paying users
	- Burn multiple (SaaS) = New user ARR / Cash burn
	- Referral, cross-sell, upsell rate
	- Magic number (SaaS) = QoQ delta in ARR / (sales and marketing cost for the previous quarter)
	- Gross Merchandise Value (e-commerce)
- **Sentiment**
	- CSAT
	- NPS
	- Social media % positive mentions
- **Performance**
	- Latency, time to impact, time to first byte
	- Round trip time
	- Throughput (max number of carts created per second)
	- Availability (includes planned and unplanned downtime)
	- Uptime (how many hours system ran smoothly out of 8760 hours in a year excluding planned downtime)
### Key metrics - New feature in a product
- **Discovery**
	- Active user count who visit page or access feature
	- % of active users who use the feature
- **Activation and Engagement**
	- Average time spent on the feature
	- Feature click-through-rate
	- If it is about micro-conversions (e.g., comments, reactions, trips taken, purchases made) then average no. of use per session 
	- change in time spent on an experience (if feature is supposed to bring efficiency) 
- **Retention**
	- Active users reusing feature 3+ times within 7 or 30 days
- **Monetization**
	- $ uplift from feature use
	- Uplift in free to paid conversion rate
	- Uplift in customer lifetime value
- **Sentiment**
	- NPS
	- CSAT
- **Performance**
	- Latency
	- Error rate
	- Drop off of user after using feature


